%       fdm65.m
%
%   iterative finite difference solution
%   Aolves Problem 6.5
%
%   plots added - contour plots seem to be fine
%
%     the following data are used:
%     vk = matrix of all potentials
%     v  = vector of potentials at internal nodes
%     n1x= number of divisions in the x direction
%     n1y= number of divisions in the y direction
%     vx1,vx2, boundary potentials on the lower and upper boundaries
%     vy1,vy2, boundary potentials on the left and right boundaries
%     eps, tolerance error per node.
%
% enter data
clear
      disp('enter coordinates of lower left and upper right ')
      c1=input('corners of solution domain [x1 y1 x2 y2] --->  ')
        x1=c1(1);
        y1=c1(2);
        x2=c1(3);
        y2=c1(4);
      c1=input('enter number of divisions in the x, y directions [n1x n1y] --->  ')
        n1x=c1(1)
        n1y=c1(2)
      c1=input('enter boundary conditions on lower, upper boundaries [vx1 vx2] --->  ')
        vx1=c1(1);
        vx2=c1(2);
      c1=input('enter boundary conditions on left, right boundaries [vy1 vy2] --->  ')
        vy1=c1(1);
        vy2=c1(2);
      disp('enter 0 if no charge in solution domain. enter 1')
      disp('if there is charge in part of the region. enter 2 if')
      ic=input('charge is distributed throughout solution domain --->  ')
      if ic==1
        disp('enter lower left and upper right corner')
        c1=input('coordinates of charge region [xa ya xb yb] --->  ')
        xa=c1(1);
        ya=c1(2);
        xb=c1(3);
        yb=c1(4);
        ro=input('enter charge density in charge region --->  ')
      	er=input('enter relative permittivity of charge region --->  ')
%        eps=input('enter required tolerance error for solution --->  ')
      end
     if ic==2
        ro=input('enter charge density in charge region --->  ')
      	er=input('enter relative permittivity of charge region --->  ')
        eps=input('enter required tolerance error for solution --->  ')
      else  eps=input('enter required tolerance error for solution --->  ')
      end

% start calculation

      n1=n1x+1;
      n2=n1y+1;
      for i=1:n1;
          for j=1:n2
              vk(i,j)=0.;
              nb(i,j)=0;
              x(i,j)=0;
              y(i,j)=0;
          end
      end

% find coordinates of all nodes in the solution domain

      dx=(x2-x1)/n1x;
    x1=x1-dx/2.0;
	x2=x2+dx/2.0;
      dy=(y2-y1)/n1y;
    y1=y1-dy/2.0;
	y2=y2+dy/2.0;
      n=0;
for i=1:n1
    xx(i)=dx*(i-1);
end
for i=1:n2
    yy(i)=dy*(i-1);
end
      for i=1:n1
          for j=1:n2
            n=n+1;
            x(i,j)=x1+(i-1)*dx;
            y(i,j)=y1+(j-1)*dy;
            vk(i,j)=0.0;
            nb(j,i)=5;
          end
      end

% set boundary conditions on upper, lower, left and right surfaces
% lower boundary is set to nb = 1 for identification purposes
% voltage on the lower boundary set to vx1

      for i=1:n1
           vk(1,i)=vx1;
           nb(1,i)=1;
      end

% upper boundary is set to nb = 2 for identification purposes
% voltage on the upper boundary set to vx2

            for i=1:n1
                vk(n2,i)=vx2;
                nb(n2,i)=2;
            end

% left boundary is set to nb = 3 and right boundaries set to nb = 4
% this is for identification only
% voltage on the left boundary set to vy1
% voltage on the left boundary set to vy2

            for i=2:n2-1
                vk(i,1)=vy1;
                vk(i,n1)=vy2;
                nb(i,1)=3;
                nb(i,n1)=4;
            end
            
% check if charge density occupies only a section of the solution domain
% if not, it is assumed there is no charge density or that it is
% uniformly distributed within the solution domain

if ic==1
        for i=1:n2
            for j=1:n1
      if (x(j,i)>xa)|(x(j,i)<xb)|(y(j,i)>ya)|(y(j,i)<yb);
      nb(j,i)=-1;
      end
            end
        end
end

% check if charge density uniformly distributed in the solution domain
% if not, it is assumed there is no charge density in the solution domain

        if ic==2
for i=1:n1;
    for j=1:n2;
      if nb(j,i)==5
          nb(j,i)=-1;
      end
    end
            end
end

% start iterative calculation of the voltage using the FDM method
% solution stop when the error criterion has been satisfied

      e0=8.854e-12;
      kk=0;
      vv=0.0;
      vv1=eps*1e10;
 while (abs(vv-vv1)>eps)
      vv1=vv;
      vv=0.;
 for i=2:n1-1
     for j=2:n2-1
            if nb(j,i)==5
                    vk(j,i)=(vk(j,i-1)+vk(j,i+1)+vk(j-1,i)+vk(j+1,i))/4.0;
            end
            if nb(j,i)==-1
                    vk(j,i)=(vk(j,i-1)+vk(j,i+1)+vk(j-1,i)+vk(j+1,i))/4.0 +ro*dx*dy/(4.0*e0*er);
            end
     end

 end
     for i=1:n1;
         for j=1:n2;
             vv=vv+vk(j,i);
         end
     end
             vv=vv/n;
      kk=kk+1;
 end
% 
% the error criterion has been met. the correct solution is in vk
%
% The following opens a file called outp to write the output using the
% fprintf command. (The output is also written to the screen)
%
fid1=fopen('outp','w');
for i=1:n2;
    for j=1:n1;
        z(i,j)=vk(i,j);
        fprintf('NODE: %2i %2i,VK= %.4f\n  ',i, j, vk(i,j));
        fprintf(fid1, 'NODE: %2i %2i,VK= %.4f\n  ',i, j, vk(i,j));
    end
end
%
% The following displays the z values as a contour plot on the screen
% displaying 11 coontours
%
[C,h]=contour(xx,yy,z,11);
clabel(C,h)
title({'Equal potential representation inside the solution space'})
xlabel('width')
ylabel('height')
%
% n is number of nodes, including boundary nodes. Listed for verification
% purposes
%
      n=n1*n2
   